<?php

namespace App\Livewire\Dashboard\Product;

use App\Models\Product\Product;
use App\Services\Product\ProductService;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Filament\Dashboard\Product\ProductForm;
use App\Enums\PostStatus;
use Filament\Notifications\Notification;

#[Layout('layouts.dashboard.dashboard-app')]
class EditProduct extends Component implements HasForms
{
    use InteractsWithForms;

    public ?array $data = [];
    public Product $product;
    
    protected ProductService $productService;

    public function boot(ProductService $productService)
    {
        $this->productService = $productService;
    }

    public function mount(string $uuid): void
    {
        $this->product = $this->productService->findByUuid($uuid);
        
        if (!$this->product) {
            abort(404);
        }

        $this->form->fill([
           

            'parent_id'             => $this->product->parent_id,
            'product_title'         => $this->product->product_title,
            'slug'                  => $this->product->slug,
            'product_description'   => $this->product->product_description,
            'product_sku'           => $this->product->product_sku,
            'link'                  => $this->product->link,
            'quantity'              => $this->product->quantity,
            'price'                 => $this->product->price,
            'created_by'            => $this->product->created_by,
            'published_at'          => $this->product->published_at,
            'expired_at'            => $this->product->expired_at,
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema(
                (new ProductForm())->getForm()
            )
            ->model($this->product ?? Product::class)
            ->statePath('data');
    }

    public function saveAsDraft(): void
    {
        $formData = $this->form->getState();
        // $formData['post_status'] = PostStatus::Draft->value;
            
            // Update post using productService with UUID
            $this->productService->updateByUuid($this->product->uuid, $formData);

            $this->form->model($this->product)->saveRelationships();

            Notification::make()
                ->success()
                ->title('Product Updated')
            ->body('Your product has been saved as draft.')
                ->duration(5000)
                ->send();
    }

    public function save(): void
    {
        $formData = $this->form->getState();
        // $formData['post_status'] = PostStatus::Pending->value;

        // Update post using productService with UUID
        $this->productService->updateByUuid($this->product->uuid, $formData);

        $this->form->model($this->product)->saveRelationships();

        Notification::make()
            ->success()
            ->title('Product Updated')
            ->body('Your product has been updated and submitted for review.')
            ->duration(5000)
            ->send();
    }

    public function cancel(): void
    {
        $this->redirect(route('dashboard.product'), navigate: true);
    }

    public function render()
    {
        return view('livewire.dashboard.product.edit-product');
    }
}
