<?php

namespace App\Livewire\Dashboard\Product;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Contracts\View\View;
use App\Services\Product\ProductService;
use Illuminate\Database\Eloquent\Builder;
use Livewire\Component;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Locked;
use Filament\Support\Enums\MaxWidth;
use Filament\Tables\Actions\Action;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\ForceDeleteBulkAction;
use Filament\Tables\Actions\RestoreBulkAction;
use App\Filament\Dashboard\Product\ProductTable;
use Illuminate\Support\Facades\Auth;

#[Layout('layouts.dashboard.dashboard-app')]
class ListProduct extends Component implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    #[Locked]
    protected $productService;

    public function boot(ProductService $productService)
    {
        $this->productService = $productService;
    }
    public function mount() {}

    public function table(Table $table): Table
    {
        return $table
            ->query($this->query())
            ->columns(
                (new ProductTable())->getTable()
            )
            ->filters(
                (new ProductTable())->getFilters()
            )
            ->filtersFormColumns(2)
            ->filtersFormWidth(MaxWidth::Medium)
            ->filtersTriggerAction(
                fn(Action $action) => $action
                    ->button()
                    ->label('Filters'),
            )
            ->actions(
                (new ProductTable())->getActions()
            )
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ])
            ->paginated([10, 25, 50, 100])
            ->defaultPaginationPageOption(25)
            ->deferLoading()
            ->defaultSort('created_at', 'desc');
    }

    public function query(): Builder
    {
        $args = [
            'user_id' => Auth::id(),
        ];
        return $this->productService->getAll($args);
    }


    public function render() : View
    {
        return view('livewire.dashboard.product.list-product');
    }
}
