<?php

namespace App\Livewire\Dashboard\Project;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use App\Services\Project\ProjectService;
use Illuminate\Database\Eloquent\Builder;
use Livewire\Component;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Locked;
use Filament\Support\Enums\MaxWidth;
use Filament\Tables\Actions\Action;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\ForceDeleteBulkAction;
use Filament\Tables\Actions\RestoreBulkAction;
use App\Filament\Dashboard\Project\ProjectTable;
use Illuminate\Support\Facades\Auth;

#[Layout('layouts.dashboard.dashboard-app')]

class ListProject extends Component implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    #[Locked]
    protected $projectService;

    public function boot(ProjectService $projectService)
    {
        $this->projectService = $projectService;
    }
    public function table(Table $table): Table
    {
        return $table
            ->query($this->query())
            ->columns(
                (new ProjectTable())->getTable()
            )
            ->filters(
                (new ProjectTable())->getFilters()
            )
            ->filtersFormColumns(2)
            ->filtersFormWidth(MaxWidth::Medium)
            ->filtersTriggerAction(
                fn(Action $action) => $action
                    ->button()
                    ->label('Filters'),
            )
            ->actions(
                (new ProjectTable())->getActions()
            )
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ])
            ->paginated([10, 25, 50, 100])
            ->defaultPaginationPageOption(25)
            ->deferLoading()
            ->defaultSort('created_at', 'desc');
    }

    public function query(): Builder
    {
        $args = [
            'user_id' => Auth::user()->id,
        ];
        return $this->projectService->getAll($args);
    }
    public function render()
    {
        return view('livewire.dashboard.project.list-project');
    }
}
