<?php

namespace App\Livewire\Dashboard\Reviews;

use Livewire\Component;
use App\Services\Review\ReviewService;
use Livewire\Attributes\Locked;
use Illuminate\Database\Eloquent\Builder;
use Livewire\Attributes\Layout;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Auth;

#[Layout('layouts.dashboard.dashboard-app')]
class Reviews extends Component
{
    use WithPagination;

    #[Locked]
    protected $reviewService;

    public $perPage = 10;


    public function boot(ReviewService $reviewService)
    {
        $this->reviewService = $reviewService;
    }


    public function render()
    {
        $args = [
            'user_id' => Auth::id(),
        ];
        
        $reviews = $this->reviewService->getAll($args)->paginate($this->perPage);
        return view('livewire.dashboard.reviews.reviews', [
            'reviews' => $reviews
        ]);
    }
}
