<?php

namespace App\Livewire\Dashboard\Team;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Contracts\View\View;
use App\Services\Team\TeamMemberService;
use Illuminate\Database\Eloquent\Builder;
use Livewire\Component;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Locked;
use Filament\Support\Enums\MaxWidth;
use Filament\Tables\Actions\Action;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\ForceDeleteBulkAction;
use Filament\Tables\Actions\RestoreBulkAction;
use App\Filament\Dashboard\Team\TeamTable;
use Illuminate\Support\Facades\Auth;

#[Layout('layouts.dashboard.dashboard-app')]

class ListTeam extends Component implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    #[Locked]
    protected $teamMemberService;

    public function boot(TeamMemberService $teamMemberService)
    {
        $this->teamMemberService = $teamMemberService;
    }
    public function mount()
    {

    }

    public function table(Table $table): Table
    {
        return $table
            ->query($this->query())
            ->columns(
                (new TeamTable())->getTable()
            )
            ->filters(
                (new TeamTable())->getFilters()
            )
            ->filtersFormColumns(2)
            ->filtersFormWidth(MaxWidth::Medium)
            ->filtersTriggerAction(
                fn(Action $action) => $action
                    ->button()
                    ->label('Filters'),
            )
            ->actions(
                (new TeamTable())->getActions()
            )
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ])
            ->paginated([10, 25, 50, 100])
            ->defaultPaginationPageOption(25)
            ->deferLoading()
            ->defaultSort('created_at', 'desc');
    }

    public function query(): Builder
    {
        $args = [
            'user_id' => Auth::user()->id,
        ];
        return $this->teamMemberService->getAll($args);
    }
    public function render() : View
    {
        return view('livewire.dashboard.team.list-team');
    }
}
