<?php

namespace App\Livewire\Dashboard\Videos;

use App\Models\User\UserVideo;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Filament\Dashboard\Video\VideoForm;
use App\Services\User\UserVideoService;
use Illuminate\Support\Facades\DB;

#[Layout('layouts.dashboard.dashboard-app')]
class CreateVideo extends Component implements HasForms
{
    use InteractsWithForms;
    protected UserVideoService $userVideoService;


    public ?array $data = [];
    public function boot(UserVideoService $userVideoService)
    {
        $this->userVideoService = $userVideoService;
    }

    public function mount(): void
    {
        $this->form->fill([
            'user_id' => Auth::id(),
            'video_link' => 'https://www.youtube.com/watch?v=dQw4w9WgXcQ',
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema(
                (new VideoForm())->getForm()
            )
            ->model(UserVideo::class)
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();
        $data['user_id'] = Auth::id();
        $data['created_by'] = Auth::id();

        try {
            DB::beginTransaction();
            $video = $this->userVideoService->create($data);

            // The form->saveRelationships() method will handle the media library upload
            // through the SpatieMediaLibraryFileUpload component
            $this->form->model($video)->saveRelationships();

            DB::commit();
            Notification::make()
                ->title('Video created successfully')
                ->success()
                ->duration(5000)
                ->send();
        } catch (\Throwable $th) {
            DB::rollBack();
            Notification::make()
                ->title('Error creating video')
                ->danger()
                ->body($th->getMessage())
                ->duration(5000)
                ->send();
        }

        $this->redirect(route('dashboard.video'));
    }

    public function render()
    {
        return view('livewire.dashboard.videos.create-video', [
            'form' => $this->form
        ]);
    }
}
