<?php

namespace App\Livewire\Dashboard\Videos;

use App\Models\User\UserVideo;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Auth;
use App\Filament\Dashboard\Video\VideoTable;
use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('layouts.dashboard.dashboard-app')]
class Videos extends Component implements HasTable, HasForms
{
    use InteractsWithTable, InteractsWithForms;

    public ?array $data = [];

    
    public function table(Table $table): Table
    {
        return $table
            ->query(function () {
                $user = Auth::user();
                if ($user->hasRole(ESP_ROLE_ADMIN)) {
                    return UserVideo::query();
                }
                return UserVideo::query()->where('user_id', Auth::id());
            })
            ->columns(
                (new VideoTable())->getTable()
            )
            ->filters(
                (new VideoTable())->getFilters()
            )
            ->actions(
                (new VideoTable())->getActions()
            )
            ->bulkActions(
                (new VideoTable())->getBulkActions()
            )
            ->emptyStateHeading('No videos yet')
            ->emptyStateDescription('Start by adding your first video')
            ->emptyStateIcon('heroicon-o-film');
    }

    public function render()
    {
        return view('livewire.dashboard.videos.videos');
    }
}
