<?php

namespace App\Livewire\Filament\Resources\Includes;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Contracts\View\View;
use Livewire\Component;

class HistorySimple extends Component implements HasTable, HasForms
{
    use InteractsWithTable;
    use InteractsWithForms;

    public $record;

    public $audits; 

    public function mount($record)
    {
        $this->record = $record;
        $this->audits = $record->audits()->orderBy('created_at', 'desc')->get();
    }

    public function query()
    {
        return $this->record->audits()->getQuery();
    }

    public function table(Table $table): Table
    {
        return $table
            ->query($this->query())
            ->columns([
                TextColumn::make('id'),
                TextColumn::make('user.name'),
                TextColumn::make('old_values') 
                    ->label('Change From'),
                    // ->formatStateUsing(fn ($state) => $this->formatValues($state)), 
                TextColumn::make('new_values') 
                    ->label('Change To'),
                    // ->formatStateUsing(fn ($state) => $this->formatValues($state)),
                TextColumn::make('created_at')
                    ->formatStateUsing(fn ($state) => $state->diffForHumans()),
            ])
            ->filters([
                //
            ]);
    }

    public function render()
    {
        return view('livewire.filament.resources.includes.history-simple');
    }
}
