<?php

declare(strict_types=1);

namespace App\Livewire\Frontend\Auth\Modal;

use Illuminate\Support\Facades\Password;
use Livewire\Attributes\Validate;
use LivewireUI\Modal\ModalComponent;

class PasswordForgotModal extends ModalComponent
{
    /** @var string */
    #[Validate('required|email')]
    public $email = '';

    public function sendPasswordResetLink()
    {
        $this->validate();

        $status = Password::sendResetLink(['email' => $this->email]);

        if ($status === Password::RESET_LINK_SENT) {
            $this->dispatch('notify', [
                'type' => 'success',
                'message' => __($status)
            ]);
            session()->flash('status', __($status));
            $this->closeModal();
            return;
        }

        $this->addError('email', __($status));
    }

    /**
     * Supported: \'sm\', \'md\', \'lg\', \'xl\', \'2xl\', \'3xl\', \'4xl\', \'5xl\', \'6xl\', \'7xl\'
     */
    public static function modalMaxWidth(): string
    {
        return 'lg';
    }

    public static function closeModalOnEscape(): bool
    {
        return true;
    }

    public static function closeModalOnClickAway(): bool
    {
        return true;
    }

    public static function closeModalOnEscapeIsForceful(): bool
    {
        return false;
    }

    public function render()
    {
        return view('livewire.frontend.auth.modal.password-forgot-modal');
    }
}
