<?php
namespace App\Livewire\Frontend\Blog;

use App\Services\Blog\PostService;
use Livewire\Component;
use Livewire\WithPagination;

class PostList extends Component
{
    use WithPagination;
    protected $postService;

    // Filters/controls coming from parent
    public $perPage   = 10;
    public $search    = '';
    public $category = [];
    public $tag       = null;
    public $author    = null;
    public $sortOrder = 'created_at';
    public $order     = 'desc';

    public function boot(PostService $postService)
    {
        $this->postService = $postService;
    }

    public function mount($params = [])
    {
        $this->perPage   = $params['perPage'] ?? $this->perPage;
        $this->search    = $params['search'] ?? request()->input('search', '');
        $this->category  = $params['categorySlug'] ?? request()->input('category');
        $this->tag       = $params['tag'] ?? request()->input('tag');
        $this->author    = $params['author'] ?? request()->input('author');
        $this->sortOrder = $params['sortOrder'] ?? 'created_at';
        $this->order     = $params['order'] ?? 'desc';
    }

    public function render()
    {
        $args = [
            'search'   => $this->search,
            'category' => $this->category,
            'tag'      => $this->tag,
            'author'   => $this->author,
            'limit'    => $this->perPage,
            'order_by' => $this->sortOrder,
            'order'    => $this->order,
        ];

        $posts = $this->postService->getAll($args)
            ->published()
            ->paginate($this->perPage);

        $posts->appends(request()->query());
        
        return view('livewire.frontend.blog.post-list', [
            'posts' => $posts,
        ]);
    }
}
