<?php

namespace App\Livewire\Frontend\Blog\Widget;

use Livewire\Component;
use App\Services\Blog\PostCategoryService;
use App\Services\Blog\PostService;

class PostWidget extends Component
{
    protected $postService;
    protected $postCategoryService;

    public $perPage = 6;
    public $type;
    public $posts;
    public $heading;
    public function boot(PostService $postService, PostCategoryService $postCategoryService,)
    {
        $this->postService         = $postService;
        $this->postCategoryService = $postCategoryService;
    }
    public function mount(string $type)
    {
        $this->type    = $type;
        switch ($type) {
            case 'feautred-first':
                $this->heading = 'Featured Articles';
                break;
            case 'latest-first':
                $this->heading = 'Latest Articles';
                break;
            case 'most-popular':
                $this->heading = 'Popular Articles';
                break;
        }
        $this->getPosts();
    }

    public function getPosts()
    {
        $args = [
            'type' => $this->type,
        ];
        if (!empty($this->perPage)) {
            $perPage = $this->perPage;
        }

        $this->posts = $this->postService->getAll($args)->published()->get()->take($perPage);
        return $this->posts;
    }
    public function render()
    {
        return view('livewire.frontend.blog.widget.post-widget');
    }
}
