<?php

namespace App\Livewire\Frontend\Classified\Modal;

use LivewireUI\Modal\ModalComponent;
use App\Services\Classified\ClassifiedService;

class ClassifiedVideoModal extends ModalComponent
{
    public $classified;
    protected $classifiedService;
    public function boot(ClassifiedService $classifiedService)
    {
        $this->classifiedService = $classifiedService;
    }
    public function mount($classified)
    {
        $this->classified = $this->classifiedService->find($classified);
        
    }

    /**
     * Supported: 'sm', 'md', 'lg', 'xl', '2xl', '3xl', '4xl', '5xl', '6xl', '7xl'
     */
    public static function modalMaxWidth(): string
    {
        return '5xl';
    }

    public static function closeModalOnEscape(): bool
    {
        return true;
    }

    public static function closeModalOnClickAway(): bool
    {
        return true;
    }

    public static function closeModalOnEscapeIsForceful(): bool
    {
        return false;
    }
    
    public function render()
    {
        return view('livewire.frontend.classified.modal.classified-video-modal');
    }
}
