<?php

namespace App\Livewire\Frontend\Components\City;

use App\Services\User\MemberCategoryService;
use Livewire\Component;

class Categories extends Component
{
    protected $memberCategoryService;
    public $pageData;

    public $heading;
    public $description;
    public $categorySlugs = [];
    public $categories;

    public function boot(MemberCategoryService $memberCategoryService)
    {
        $this->memberCategoryService = $memberCategoryService;
    }
    public function mount($pageData=[])
    {
        $this->pageData = $pageData;
        $this->heading     = $this->pageData['heading'];
        $this->description = $this->pageData['description'];
        $this->categorySlugs  = $this->pageData['categories'];
        
    }

    public function getCategories(){
        $query = $this->memberCategoryService->getAll();
        if(!empty($this->categorySlugs) && is_array($this->categorySlugs)){
            $query->whereIn('slug', $this->categorySlugs);
        }
        $this->categories = $query->get();
    }
    public function render()
    {
        $query = $this->memberCategoryService->getAll();
        if(!empty($this->categorySlugs) && is_array($this->categorySlugs)){
            $query->whereIn('slug', $this->categorySlugs);
        }
        $this->categories = $query->get();
        return view('livewire.frontend.components.city.categories');
    }
}
