<?php

namespace App\Livewire\Frontend\Job\Modal;

use LivewireUI\Modal\ModalComponent;
use App\Services\Job\JobService;

class ApplicationConfirm extends ModalComponent
{
    public $job;

    public function mount($job, JobService $jobService)
    {
        $this->job = $jobService->find($job);
    }

    /**
     * Supported: 'sm', 'md', 'lg', 'xl', '2xl', '3xl', '4xl', '5xl', '6xl', '7xl'
     */
    public static function modalMaxWidth(): string
    {
        return '5xl';
    }

    public function render()
    {
        $args = [
            'job' => $this->job,
            'limit' => 3,
        ];
        $jobService = app(JobService::class);
        $relatedJobs = $jobService->getRelatedJobs($args);
        return view('livewire.frontend.job.modal.application-confirm', compact('relatedJobs'));
    }
}
