<?php

namespace App\Livewire\Frontend\Member\Listing\SearchResult;

use App\Models\Location\Country;
use App\Services\Location\CityService;
use App\Services\Location\CountryService;
use App\Services\Location\StateService;
use App\Services\Review\ReviewService;
use App\Services\User\MemberCategoryService;
use App\Services\User\UserService;
use Livewire\Component;

class SearchResultListView extends Component
{
    use MemberSearchTrait, MemberCategoryTrait;

    protected $memberList = [];

    public $profileReviewsCount;
    public $profileEmergencyCount;
    public $profileOpenNowCount;

    public function boot(
        UserService $userService,
        MemberCategoryService $memberCategoryService,
        CountryService $countryService,
        StateService $stateService,
        CityService $cityService,
        ReviewService $reviewService
    ) {
        $this->userService = $userService;
        $this->memberCategoryService = $memberCategoryService;
        $this->countryService = $countryService;
        $this->stateService = $stateService;
        $this->cityService = $cityService;
        $this->reviewService = $reviewService;
    }

    public function mount($page, $viewType, $breadcrumbs)
    {
        $this->page = $page;
        $this->viewType = $viewType ?? $page->data['member_list_template']['default_view'] ?? 'list';
        $this->breadcrumbs = $breadcrumbs;

        // Initialize empty collections
        $this->categoriesList = collect();
        $this->subcategoriesList = collect();
        $this->specificCategoriesList = collect();
        $this->stateList = collect();
        $this->cityList = collect();

        // Initialize lists
        $this->getParentCategories();
        $this->getChildCategories();
        $this->getSpecificCategories();
        $this->getCountryList();

        // Load states if country is selected
        if (! empty($this->country)) {
            $this->getStatesList();
            $countryModel = Country::where('slug', $this->country)->first();
            if ($countryModel) {
                $this->countryCode = $countryModel->country_code;
            }
        }

        // Load cities if states are selected
        if (! empty($this->state)) {
            $this->getCitiesList();
        }

        $this->getRadiusList();
        $this->getProfileFeatures();

        // Parse location string into lat/lng if provided
        $this->parseLocationString();

        $this->generateSearchForText();

        $this->parseSortOrder();

        $this->memberList = $this->getAllMembers();

        $this->getProfileMetaCount();
    }

    // get profile meta counts
    public function getProfileMetaCount()
    {
        // Get member IDs from the member list
        // Get profile meta counts for the specific members
        $this->profileReviewsCount = esp_get_profile_meta_count($this->memberList, 'reviews');
        $this->profileEmergencyCount = esp_get_profile_meta_count($this->memberList, 'emergency');
        $this->profileOpenNowCount = esp_get_profile_meta_count($this->memberList, 'open_now');
    }



    public function getAllMembers()
    {
        $args = $this->prepareSearchArgs(true);

        // Add category-related arguments
        $args['category'] = $this->category;
        $args['subcategory'] = $this->subcategory;
        $args['service'] = $this->service;
        $args['specificCategory'] = $this->specificCategory;
        return $this->userService->getMemberList($args);
    }

    public function render()
    // Apply filter params logic
    {
        $members = $this->getAllMembers();
        $this->totalRecords = $members->total();
        $this->totalPages = $members->lastPage();
        $this->currentPage = $members->currentPage();

        return view('livewire.frontend.member.listing.search-result.search-result-list-view', [
            'members' => $members,
        ]);
    }
}
