<?php

namespace App\Livewire\Frontend\Member\Modal;

use LivewireUI\Modal\ModalComponent;
use App\Services\User\UserVideoService;

class PlayVideoModal extends ModalComponent
{
    public $video;
    public $videoData;

    protected $userVideoService;
    public function boot(UserVideoService $userVideoService)
    {
        $this->userVideoService = $userVideoService;
    }
    public function mount($video)
    {
        $this->videoData = $this->userVideoService->find($video);
        $this->video = $this->videoData;
    }

    /**
     * Supported: 'sm', 'md', 'lg', 'xl', '2xl', '3xl', '4xl', '5xl', '6xl', '7xl'
     */
    public static function modalMaxWidth(): string
    {
        return '5xl';
    }

    public static function closeModalOnEscape(): bool
    {
        return true;
    }

    public static function closeModalOnClickAway(): bool
    {
        return true;
    }

    public static function closeModalOnEscapeIsForceful(): bool
    {
        return false;
    }

    public function render()
    {
        return view('livewire.frontend.member.modal.play-video-modal');
    }
}
