<?php

namespace App\Livewire\Frontend\Member\ProfileTabs;

use App\Services\Blog\PostCategoryService;
use App\Services\Blog\PostService;
use Livewire\Component;
use Livewire\WithPagination;
use App\Services\User\UserService;

class ArticleTab extends Component
{
    use WithPagination;

    public $userId  = null;
    public $perPage = 12;
    public $filters = null;
    public $category_slug;
    public $search = '';

    protected $queryString = ['filters'];

    public $user;
    /**
     * Initializes the component and injects the PostService dependency.
     *
     * @param PostService $postService The service for managing blog posts.
     *
     * @return void
     */
    public function mount($userId)
    {
        $this->userId = $userId;
        $this->user = resolve(UserService::class)->find($userId);
        // Initialize the filters property during mount instead of class property declaration
        $this->filters = [];
    }

    public function render()
    {
        $postService = resolve(PostService::class);
        $postCategoryService = resolve(PostCategoryService::class);
        
        $posts = collect(); // Default to an empty collection
        if ($this->user) {
            $args = [
                'author' => $this->user->slug,
                'category' => $this->category_slug,
                'search' => $this->search,
            ];
            $posts = $postService->getAll($args)
                ->orderBy('published_at', 'desc')
                ->published()
                ->paginate($this->perPage, pageName: '?tab=articles');
        }
        
        $categories = $postCategoryService->getAll()->get();
        return view('livewire.frontend.member.profile-tabs.article-tab', ['articles' => $posts, 'categories' => $categories]);
    }
}
