<?php

namespace App\Livewire\Frontend\Member\ProfileTabs;

use App\Services\Classified\ClassifiedService;
use Livewire\Component;
use Livewire\WithPagination;
use Livewire\Attributes\On;
use App\Services\User\UserService;

class ClassifiedTab extends Component
{
    use WithPagination;
    public $userId;
    public $perPage = 10;
    public $search = '';
    public $isLoaded = false;
    public $user;

    public function mount($userId)
    {
        $this->userId = $userId;
        $this->user = resolve(UserService::class)->find($userId);
    }

    #[On('classified-tab-activated')]
    public function loadTab()
    {
        $this->isLoaded = true;
        // Dispatch Livewire event
        $this->dispatch('classified-component-loaded');

        // Also dispatch a browser event to be extra safe
        $this->dispatch('classified-component-loaded-js', name: 'classified-component-loaded');
    }

    public function updatedSearch()
    {
        $this->resetPage('classified-page');
    }

    public function render()
    {
        $classifiedService = resolve(ClassifiedService::class);
        $classifieds = collect(); // Default to an empty collection

        if ($this->user) {
            $args = [
                'user_id' => $this->user->id,
                'search' => $this->search,
                'order_by' => 'created_at',
                'order' => 'desc',
            ];

            $classifieds = $classifiedService->getAll($args)
                ->paginate($this->perPage, pageName: '?tab=classifieds');
        }

        return view('livewire.frontend.member.profile-tabs.classified-tab', [
            'classifieds' => $classifieds,
        ]);
    }
}
