<?php

namespace App\Livewire\Frontend\Member\ProfileTabs;

use Livewire\Component;
use Livewire\WithPagination;
use App\Services\Equipment\EquipmentService;
use App\Services\User\UserService;

class EquipmentTab extends Component
{
    use WithPagination;

    public $userId = null;
    public $perPage = 6;
    public $filters = null;
    public $search = '';
    public $viewType = 'list';
    public $user;

    public function mount($userId)
    {
        $this->userId = $userId;
        $this->viewType = 'list'; // Set list view as default
        $this->user = resolve(UserService::class)->find($userId);
    }

    public function setViewType($type)
    {
        $this->viewType = $type;
    }

    public function render()
    {
        $equipmentService = resolve(EquipmentService::class);
        $equipments = collect(); // Default to an empty collection

        if ($this->user) {
            $args = [
                'user_id' => $this->user->id,
                'search' => $this->search,
            ];

            $equipments = $equipmentService
                ->getAll($args)
                ->orderBy('created_at', 'desc')
                ->paginate(
                    $this->perPage,
                    pageName: '?tab=equipments',
                );
        }

        return view('livewire.frontend.member.profile-tabs.equipment-tab', ['equipments' => $equipments, 'user' => $this->user]);
    }
}
