<?php
namespace App\Livewire\Frontend\Member\ProfileTabs;

use Livewire\Component;
use Livewire\WithPagination;
use App\Services\Job\JobService;

class JobTab extends Component
{
    use WithPagination;
    public $userId  = null;
    public $perPage = 12;
    public $filters = null;
    public $title   = '';

    public function mount($userId)
    {
        $this->userId = $userId;
    }

    public function render()
    {
        $jobService = resolve(JobService::class);
        $jobs = collect(); // Default to an empty collection

        if ($this->userId) {
            $args = [
                'user_id' => $this->userId,
                'search'  => $this->title,
            ];
            $jobs = $jobService
                ->getAll($args)
                ->orderBy('created_at', 'desc')
                ->paginate(
                    $this->perPage,
                    pageName: '?tab=jobs',
                );
        }
        return view('livewire.frontend.member.profile-tabs.job-tab',['jobs' => $jobs]);
    }
}   
