<?php

namespace App\Livewire\Frontend\Member\ProfileTabs\Partials;

use Livewire\Component;
use Livewire\WithPagination;
use App\Services\Job\JobService;


class TeamMemberLatestJobs extends Component
{
    use WithPagination;
    
    protected $jobService;
    
    public $userId = null;
    public $perPage = 10;
    
    public function boot(JobService $jobService)
    {
        $this->jobService = $jobService;
    }
    
    public function mount($userId)
    {
        $this->userId = $userId;
    }
    
    public function render()
    {
        $args = [
            'user_id' => $this->userId,
            'order_by' => 'created_at',
            'order' => 'desc',
        ];
        
        $latestJobs = $this->jobService
            ->getAll($args)
            ->paginate($this->perPage, pageName: 'jobs-page');
            
        return view('livewire.frontend.member.profile-tabs.partials.team-member-latest-jobs', [
            'latestJobs' => $latestJobs
        ]);
    }
} 