<?php

namespace App\Livewire\Frontend\Member\ProfileTabs;

use Livewire\Component;
use App\Services\Project\ProjectService;
use Livewire\WithPagination;
use Livewire\WithoutUrlPagination;
use App\Services\User\UserService;

class ProjectTab extends Component
{
    use WithPagination;

    // Simple nullable public properties without type declarations
    public $userId = null;
    public $perPage = 10;
    public $filters = null;

    // Initialize filters correctly
    protected $queryString = ['filters'];

    public $user;

    // Set up property in mount instead of declaration
    public function mount($userId)
    {
        $this->userId = $userId;
        $this->user = resolve(UserService::class)->find($userId);
        // Initialize the filters property during mount instead of class property declaration
        $this->filters = [];
    }

    public function render()
    {
        $projectService = resolve(ProjectService::class);
        $projects = collect(); // Default to an empty collection

        if ($this->user) {
            $args = [
                'user_id' => $this->user->id,
            ];
            $projects = $projectService->getAll($args)
                ->published()
                ->orderBy('created_at', 'desc')
                ->paginate($this->perPage, pageName: '?tab=projects');
        }
        return view('livewire.frontend.member.profile-tabs.project-tab', [
            'projects' => $projects,
        ]);
    }
}
