<?php

namespace App\Livewire\Frontend\Member\ProfileTabs;

use App\Services\Review\ReviewService;
use App\Services\User\UserService;
use Livewire\Component;
use Livewire\WithPagination;

class ReviewTab extends Component
{
    use WithPagination;
    protected $listeners = ['reviewSubmitted'];
    public $userId = null;
    public $perPage = 10;
    public $user;
    public $reviewsStats;
    
    protected $paginationTheme = 'esp-sleek';

    public function mount($userId, $reviewsStats)
    {
        $this->userId = $userId;
        $this->user = resolve(UserService::class)->find($this->userId);
        $this->reviewsStats = $reviewsStats;
    }

    public function refreshReviews()
    {
        $this->resetPage('tab-reviews');
    }

    public function render()
    {
        $reviewService = resolve(ReviewService::class);
        $reviews = collect(); // Default to an empty collection

        if ($this->userId) {
            $reviews = $reviewService->getReviewsByReviewable(
                type: "App\\Models\\User\\User",
                id: $this->userId
            )
                ->has('user')
                ->orderBy('created_at', 'desc')
                ->paginate(perPage:$this->perPage, pageName:'tab-reviews');
        }

        return view('livewire.frontend.member.profile-tabs.review-tab', [
            'reviews' => $reviews
        ]);
    }
}
