<?php

namespace App\Livewire\Frontend\Member\ProfileTabs;

use Livewire\Component;
use App\Services\User\UserService;
use App\Services\User\UserServiceService;
use Livewire\WithPagination;

class ServiceTab extends Component
{
    use WithPagination;

    public $perPage = 10;
    public $filters = null;
    public $user = null;

    protected $queryString = ['filters'];

    public function mount($userId)
    {
        $this->user = resolve(UserService::class)->find($userId);
        $this->filters = [];
    }

    public function render()
    {
        $userServiceService = resolve(UserServiceService::class);
        $services = collect(); // Default to an empty collection

        if ($this->user) {
            $services = $userServiceService->getUserServices($this->user->id)
                ->paginate($this->perPage, pageName: '?tab=services');
        }

        return view('livewire.frontend.member.profile-tabs.service-tab', [
            'services' => $services,
        ]);
    }
}
