<?php

namespace App\Livewire\Frontend\Member\ProfileTabs;

use Livewire\Component;
use Livewire\WithPagination;
use App\Services\Team\TeamMemberService;
use App\Models\User\User;

class TeamTab extends Component
{
    use WithPagination;
    public $userId  = null;
    public $perPage = 10;
    public $user;

    public function mount($userId)
    {
        $this->userId = $userId;
        $this->user = User::find($userId);
    }
    public function render()
    {
        $teamMemberService = resolve(TeamMemberService::class);
        $teamMembers = collect(); // Default to an empty collection

        if ($this->userId) {
            $args = [
                'user_id' => $this->userId,
            ];
            $teamMembers = $teamMemberService
                ->getAll($args)
                ->orderBy('created_at', 'desc')
                ->paginate($this->perPage, pageName: '?tab=team');
        }
        return view('livewire.frontend.member.profile-tabs.team-tab', ['teamMembers' => $teamMembers]);
    }
}
