<?php

namespace App\Livewire\Frontend\Member\ProfileTabs;

use App\Services\User\UserService;
use App\Services\User\UserVideoService;
use Livewire\Component;
use Livewire\WithPagination;

class VideoTab extends Component
{
    use WithPagination;

    public $userId = null;
    public $perPage = 12;
    public $filters = null;
    public $search = '';
    public $user;

    protected $queryString = ['filters'];

    /**
     * Initializes the component and injects the UserVideoService dependency.
     *
     * @param UserVideoService $userVideoService The service for managing user videos.
     *
     * @return void
     */
    public function mount($userId)
    {
        $this->userId = $userId;
        // Initialize the filters property during mount instead of class property declaration
        $this->filters = [];
        $this->user = resolve(UserService::class)->find($this->userId);
    }

    public function render()
    {
        $userVideoService = resolve(UserVideoService::class);
        $videos = collect(); // Default to an empty collection

        if ($this->user) {
            $args = [
                'user_id' => $this->user->id,
                'search' => $this->search,
            ];

            $videos = $userVideoService->getAll($args)
                ->orderBy('created_at', 'desc')
                ->paginate(
                    $this->perPage,
                    pageName: '?tab=videos'
                );
        }

        return view('livewire.frontend.member.profile-tabs.video-tab', ['videos' => $videos]);
    }
}
