<?php

namespace App\Livewire\Frontend\TeamMember\Modal;

use LivewireUI\Modal\ModalComponent;
use App\Services\Team\TeamMemberService;

class TeamMemberDetail extends ModalComponent
{
    public $teamMember;

    public function mount($member, TeamMemberService $teamMemberService)
    {
        $this->teamMember = $teamMemberService->findByUuid($member);
    }

    public function render()
    {
        return view('livewire.frontend.team-member.modal.team-member-detail');
    }

    /**
     * Supported: 'sm', 'md', 'lg', 'xl', '2xl', '3xl', '4xl', '5xl', '6xl', '7xl'
     */
    public static function modalMaxWidth(): string
    {
        return '4xl';
    }
}
