<?php

namespace App\Livewire\Frontend\Widgets;

use Livewire\Component;
use App\Services\Classified\ClassifiedService;
use App\Models\Classified\ClassifiedType;
use App\Models\Classified\ClassifiedCategory;

class ClassifiedList extends Component
{
    protected $classifiedService;
    protected $pageData;
    public $limit = 3;
    public $component;
    public $heading;
    public $description;
    public $classifieds;

    public function boot(ClassifiedService $classifiedService)
    {
        $this->classifiedService = $classifiedService;
    }

    public function mount($pageData = [])
    {
        $this->pageData = $pageData;
        $component = $pageData['classified_list'];
        $this->component = $component;
        $this->heading = !empty($component['heading']) ? $component['heading'] : null;
        $this->description = !empty($component['description']) ? $component['description'] : 'Classifieds';
        $this->limit = !empty($component['limit']) ? $component['limit'] : $this->limit;
        $this->getTopClassifieds();
    }

    public function getTopClassifieds()
    {
        $componentData = $this->component ?? [];

        // 1) Selected classifieds: fetch exactly by provided IDs
        if (!empty($componentData['selected_classifieds'])) {
            $selectedIds = $componentData['selectedClassifiedIds'] ?? $componentData['classifieds'] ?? [];
            $selectedIds = array_values(array_filter(array_map('intval', (array) $selectedIds)));

            if (!empty($selectedIds)) {
                $this->classifieds = $this->classifiedService
                    ->getAll()
                    ->whereIn('classifieds.id', $selectedIds)
                    ->get();
                return;
            }
        }

        // 2) Latest classifieds with filters
        if (!empty($componentData['latest_classifieds'])) {
            $args = [
                'limit' => $this->limit,
                'order_by' => 'created_at',
                'order' => 'desc',
            ];

            // Location: allow either ids or slugs/strings
            if (!empty($componentData['city_id'])) {
                $args['city'] = (int) $componentData['city_id'];
            } elseif (!empty($componentData['state_id'])) {
                $args['state'] = (int) $componentData['state_id'];
            }
            if (!empty($componentData['country_id'])) {
                $args['country'] = (int) $componentData['country_id'];
            }
            if (!empty($componentData['city'])) {
                $args['city'] = $componentData['city'];
            }
            if (!empty($componentData['state'])) {
                $args['state'] = $componentData['state'];
            }
            if (!empty($componentData['country'])) {
                $args['country'] = $componentData['country'];
            }
            if (!empty($componentData['contry'])) { // tolerate misspelling
                $args['country'] = $componentData['contry'];
            }

            // Ad type: repository expects IDs or slugs array handled by service
            if (!empty($componentData['type'])) {
                $typeIds = (array) $componentData['type'];
                // Convert IDs to slugs if needed; service can also convert slugs to IDs
                $typeSlugs = ClassifiedType::query()
                    ->whereIn('id', $typeIds)
                    ->pluck('slug')
                    ->filter()
                    ->values()
                    ->all();
                $args['type'] = !empty($typeSlugs) ? $typeSlugs : $typeIds;
            }

            // Category / Sub-category map to 'categories' via service filterSearchParams
            if (!empty($componentData['category'])) {
                $args['mainCategory'] = (array) $componentData['category'];
            }
            if (!empty($componentData['sub_category'])) {
                $args['subCategory'] = (array) $componentData['sub_category'];
            }

            // Condition (repository expects array of values)
            if (!empty($componentData['condition'])) {
                $args['condition'] = (array) $componentData['condition'];
            }

            // Item Age mapping like JobList did, using service->filterSearchParams
            if (!empty($componentData['item_age'])) {
                $args['itemAge'] = $componentData['item_age'];
            }

            // Date posted mapping to days
            if (!empty($componentData['date_posted'])) {
                $map = [
                    '24_hours' => 1,
                    '7_days' => 7,
                    '30_days' => 30,
                    'any' => null,
                ];
                $days = $map[$componentData['date_posted']] ?? null;
                if (!empty($days)) {
                    $args['datePosted'] = $days;
                }
            }

            // Let service normalize and fetch
            $args = $this->classifiedService->filterSearchParams($args);
            $this->classifieds = $this->classifiedService->getAll($args)->get();
            return;
        }

        // 3) Default latest classifieds limited
        $args = [
            'limit' => $this->limit,
            'order_by' => 'created_at',
            'order' => 'desc',
        ];
        $this->classifieds = $this->classifiedService->getAll($args)->get();
    }
    public function render()
    {
        return view('livewire.frontend.widgets.classified-list');
    }
}
