<?php

namespace App\Livewire\Frontend\Widgets;

use Livewire\Component;
use Illuminate\Support\Facades\Storage;

class EstimateBanner extends Component
{
    public $pageData = [];
    public $component = [];
    public $heading;
    public $description;
    public $lead_bg_img;


    public function mount($pageData = [])
    {
        $this->pageData = $pageData ?? [];
        $this->component = $this->pageData['estimate_banner'] ?? [];
        $this->heading = !empty($this->component['heading']) ? $this->component['heading'] : 'Get an online estimate for the cost to drill a water well';
        $this->description = !empty($this->component['description']) ? $this->component['description'] : 'As the trusted local well drilling contractor, our online system is the straightforward, no-hassle way to get rock-solid, site-specific water well prices. It ensures all necessary details are gathered upfront, saving you time and the frustration of phone tag. Please enter your address to begin.';
        $this->lead_bg_img = !empty($this->component['lead_bg_img']) ? Storage::url($this->component['lead_bg_img']) : asset('images/start-banner-bg.jpg');
    }

    public function render()
    {
        return view('livewire.frontend.widgets.estimate-banner');
    }
}


