<?php

namespace App\Livewire\Frontend\Widgets;

use Livewire\Component;

class Faqs extends Component
{
    protected $pageData;

    public $heading;
    public $description;
    public $faqs;
    public $component;
    // public $desktop_background_image;
    // public $mobile_background_image;
    public function mount($pageData = [])
    {
        $component = $pageData['faqs'];
        $this->component = $component;
        $this->heading = !empty($component['heading']) ? $component['heading'] : 'Frequently asked questions';
        $this->description = !empty($component['description']) ? $component['description'] : 'You’ve got questions, we’ve hot answers';
        $this->faqs = !empty($component['faqs']) ? $component['faqs'] : [];
    }

    public function render()
    {
        return view('livewire.frontend.widgets.faqs');
    }
}
