<?php

namespace App\Livewire\Frontend\Widgets;

use Livewire\Component;
use App\Services\User\MemberPlanService;
use Illuminate\Support\Facades\Storage;

class PackageList extends Component
{

    protected $memberPlanService;
    protected $component;
    public $heading;
    public $description;
    public $limit = 4;
    public $packages;
    public $price_desktop_background_image;
    public $price_mobile_background_image;

    public $isYearly = true;


    public function boot(MemberPlanService $memberPlanService)
    {
        $this->memberPlanService = $memberPlanService;
    }

    public function mount($pageData = [])
    {
        $component = $pageData['package_list'];
        $this->component = $component;
        $this->heading = !empty($component['heading']) ? $component['heading'] : '<p>ESP <em>marketplace</em></p>';
        $this->description = !empty($component['description']) ? $component['description'] : 'Plans made to work for your business.';
        $desktop_background_image = !empty($component['background_image']) ? $component['background_image'] : null;
        $mobile_background_image = !empty($component['mobile_background_image']) ? $component['mobile_background_image'] : null;
        $this->price_desktop_background_image = !empty($desktop_background_image) ? Storage::url($desktop_background_image) : asset('images/price-bg.svg');
        $this->price_mobile_background_image = !empty($mobile_background_image) ? Storage::url($mobile_background_image) : asset('images/price-bg-mobile.svg');
        $this->getPackages();
    }

    public function changeType($type)
    {
        $this->isYearly = $type === 'yearly';
    }

    public function getPackages()
    {
        $args = [
            'is_active' => 1,
            'limit' => $this->limit,
            'order_by' => 'display_order',
            'order' => 'asc',
        ];
        $this->packages = $this->memberPlanService->getAll($args)->get();
    }

    public function render()
    {
        return view('livewire.frontend.widgets.package-list');
    }
}
