<?php

namespace App\Livewire\Frontend\Widgets;

use Livewire\Component;
use App\Services\User\MemberCategoryService;

class Services extends Component
{

    protected $memberCategoryService;
    protected $pageData;

    public $component;
    public $limit = 12;
    public $categories;
    public $heading;
    public $description;

    public function boot(MemberCategoryService $memberCategoryService)
    {
        $this->memberCategoryService = $memberCategoryService;
    }

    public function mount($pageData = [])
    {
        $component = $pageData['services'];
        $this->component = $component;
        $this->heading = !empty($component['heading']) ? $component['heading'] : '<p>Other <em>Services</em></p>';
        $this->description = !empty($component['description']) ? $component['description'] : 'Want the top spot, get featured now.';
        $this->limit = !empty($component['limit']) ? $component['limit'] : $this->limit;
        $this->getCategories();
    }

    public function getCategories()
    {
        $componentData = $this->component ?? [];

        // 1) Selected categories by IDs: fetch exactly provided IDs
        $selectedIds = $componentData['selectedCategoryIds']
            ?? $componentData['selectedIds']
            ?? $componentData['categories']
            ?? [];
        $selectedIds = array_values(array_filter(array_map('intval', (array) $selectedIds)));

        if (!empty($selectedIds)) {
            $this->categories = $this->memberCategoryService
                ->getAll()
                ->whereIn('member_categories.id', $selectedIds)
                ->get();
            return;
        }

        // 2) Default: limited list
        $args = [
            'limit' => $this->limit,
        ];
        $this->categories = $this->memberCategoryService->getAll($args)->get();
    }

    public function render()
    {
        return view('livewire.frontend.widgets.services');
    }
}
