<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Models\Traits\CreatedByTrait;
use App\Models\User\User;
use App\Enums\ApiClientType;
use Laravel\Sanctum\HasApiTokens;

class ApiClient extends Authenticatable
{
    use HasFactory, HasApiTokens, CreatedByTrait;

    protected $fillable = [
        'name',
        'type',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'type' => ApiClientType::class,
        'is_active' => 'boolean',
    ];

    /**
     * Get the user who created this API client
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
