<?php

namespace App\Models\Classified;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use RalphJSmit\Laravel\SEO\Support\HasSEO;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;


class ClassifiedCategory extends Model
{
    use HasSlug, CreatedByTrait, HasUuidTrait, SoftDeletes, HasFactory, HasSEO;

    protected $fillable = [
        'uuid',
        'classified_category_name',
        'classified_category_description',
        'slug',
        'meta_title',
        'meta_description',
        'is_active',
        'created_by',
        'parent_id'
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()->generateSlugsFrom('classified_category_name')->saveSlugsTo('slug');
    }

    public function classifieds(): BelongsToMany
    {
        return $this->belongsToMany(Classified::class, 'classified_classified_category');
    }

    /**
     * Get the parent category
     */
    public function parent(): BelongsTo
    {
        return $this->belongsTo(ClassifiedCategory::class, 'parent_id');
    }

    /**
     * Get the child categories
     */
    public function children(): HasMany
    {
        return $this->hasMany(ClassifiedCategory::class, 'parent_id');
    }
} 