<?php

namespace App\Models\Classified;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\Traits\CreatedByTrait;
use App\Models\User\User;
use RalphJSmit\Laravel\SEO\Support\HasSEO;

class ClassifiedDelivery extends Model
{
    use HasFactory, SoftDeletes, HasUuidTrait, HasSlug, CreatedByTrait, HasSEO;

    // Fillable
    protected $fillable = [
        'uuid',
        'name',
        'slug',
        'description',
        'is_active',
        'parent_id',
        'created_by',
    ];




    // Slug
    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }

    // Relation classifieds with classified_classified_delivery table
    public function classifieds(): BelongsToMany
    {
        return $this->belongsToMany(Classified::class);
    }

    //Parent Delivery
    public function parent(): BelongsTo
    {
        return $this->belongsTo(ClassifiedDelivery::class, 'parent_id');
    }

    //Child Deliveries
    public function children(): HasMany
    {
        return $this->hasMany(ClassifiedDelivery::class, 'parent_id');
    }

    //Author
    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
