<?php

namespace App\Models\Classified;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ClassifiedTag extends Model
{
    use HasSlug, CreatedByTrait, HasUuidTrait, SoftDeletes, HasFactory;

    protected $fillable = [
        'uuid',
        'classified_tag_name',
        'is_active',
        'slug',
        'created_by'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()->generateSlugsFrom('classified_tag_name')->saveSlugsTo('slug')->doNotGenerateSlugsOnUpdate();
    }

    public function classifieds(): BelongsToMany
    {
        return $this->belongsToMany(Classified::class, 'classified_classified_tag');
    }
} 