<?php

namespace App\Models\Classified;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use RalphJSmit\Laravel\SEO\Support\HasSEO;

class ClassifiedType extends Model
{
    use HasSlug, CreatedByTrait, HasUuidTrait, SoftDeletes, HasFactory, HasSEO;

    protected $fillable = [
        'uuid',
        'classified_type_name',
        'classified_type_description',
        'created_by',
        'is_active',
        'slug',
        'parent_id',
        'created_by'
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()->generateSlugsFrom('classified_type_name')->saveSlugsTo('slug');
    }

    public function classifieds(): BelongsToMany
    {
        return $this->belongsToMany(Classified::class, 'classified_classified_type');
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(ClassifiedType::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(ClassifiedType::class, 'parent_id');
    }
} 