<?php

namespace App\Models;

use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\User\User;
class Currency extends Model
{
    use HasUuidTrait, CreatedByTrait, SoftDeletes, HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<string>
     */
    protected $fillable = [
        'uuid',
        'currency_name',
        'currency_code',
        'currency_rate',
        'currency_symbol',
        'is_active',
        'is_default',
        'created_by'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'currency_rate' => 'decimal:3',
        'currency_data' => 'array',
    ];

    /**
     * Get the user that created the currency.
     */
    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getCurrencyNameAttribute($value): string
    {
        return strtoupper($value);
    }
}
