<?php

namespace App\Models\Equipment\Traits;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Collection;

trait EquipmentHelperTrait
{
    public function getEquipmentCategories($limit = 3): Collection
    {
        $categories = collect([]);
        if ($this->categories->isNotEmpty()) {
            $categories = $this->categories->take($limit);
        }
        return $categories;
    }

    public function getEquipmentFullAddress(string $type = 'full'): ?string
    {
        $addressParts = [];
        $stateCode = null;

        if ($this->address_line_1) {
            $addressParts['address_line_1'] = $this->address_line_1;
        }

        if ($this->city()->exists()) {
            $addressParts['city'] = $this->city->city_name;
        }

        if ($this->state()->exists()) {
            $addressParts['state'] = $this->state->state_name;
            $stateCode = $this->state->state_code;
        }

        if ($this->country()->exists()) {
            $addressParts['country'] = $this->country->country_name;
        }

        if ($this->postal_code) {
            $addressParts['postal_code'] = $this->postal_code;
        }

        if ($type == 'short') {
            unset($addressParts['address_line_1']);
            unset($addressParts['postal_code']);
        }

        if ($type == 'area') {
            unset($addressParts['address_line_1']);
            unset($addressParts['country']);
            unset($addressParts['postal_code']);

            if ($stateCode) {
                unset($addressParts['state']);
                $addressParts['state'] = $stateCode;
            }
        }

        return !empty($addressParts) ? implode(', ', $addressParts) : '';
    }

    public function isFavorite(): bool
    {
        if (!Auth::check()) {
            return false;
        }
        return Auth::user()->favoriteEquipment()->where('model_id', $this->id)->exists();
    }

    public function getPermalinkAttribute(): string
    {
        return route('equipment.show', $this->slug);
    }
}
