<?php

namespace App\Models\Job;

use App\Models\User\User;
use App\Enums\JobApplicationStatus;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class JobApplication extends Model implements HasMedia
{
    use HasUuidTrait, SoftDeletes, HasFactory, InteractsWithMedia;

    protected $table = 'job_application';

    protected $fillable = [
        'uuid',
        'job_id',
        'applicant_id',
        'application_status',
        'application_data'
    ];

    protected $casts = [
        'application_status' => JobApplicationStatus::class,
        'application_data' => 'array',
    ];

    public function job(): BelongsTo
    {
        return $this->belongsTo(Job::class);
    }

    public function applicant(): BelongsTo
    {
        return $this->belongsTo(User::class, 'applicant_id');
    }

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('resume')
            ->singleFile()
            ->acceptsMimeTypes(['application/pdf']);
    }
}
