<?php

namespace App\Models\Job;

use App\Models\User\User;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class JobCareerLevel extends Model
{
    use HasUuidTrait, CreatedByTrait, SoftDeletes, HasFactory, HasSlug;

    protected $table = 'job_career_level';

    protected $fillable = [
        'career_level_name',
        'career_level_description',
        'slug',
        'is_active',
        'created_by'
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()->generateSlugsFrom('career_level_name')->saveSlugsTo('slug')->doNotGenerateSlugsOnUpdate();
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function jobs(): HasMany
    {
        return $this->hasMany(Job::class);
    }

    public function children(): HasMany 
    {
        return $this->hasMany(JobCareerLevel::class, 'parent_id');
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(JobCareerLevel::class, 'parent_id');
    }
} 