<?php

namespace App\Models\Job;

use App\Models\User\User;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class JobIndustry extends Model
{
    use HasUuidTrait, CreatedByTrait, SoftDeletes, HasFactory, HasSlug;

    protected $fillable = [
        'uuid',
        'industry_name',
        'industry_description',
        'slug',
        'is_active',
        'created_by'
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()->generateSlugsFrom('industry_name')->saveSlugsTo('slug')->doNotGenerateSlugsOnUpdate();
    }

    public function jobs(): HasMany
    {
        return $this->hasMany(Job::class);
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
} 