<?php

namespace App\Models\Job;

use App\Models\User\User;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Sluggable\HasSlug;
use Illuminate\Database\Eloquent\Builder;
use Spatie\Sluggable\SlugOptions;

class JobRole extends Model
{
    use HasUuidTrait, CreatedByTrait, SoftDeletes, HasFactory, HasSlug;

    protected $fillable = [
        'uuid',
        'job_role_name',
        'slug',
        'job_role_description',
        'parent_id',
        'is_active',
        'created_by'
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()->generateSlugsFrom('job_role_name')->saveSlugsTo('slug')->doNotGenerateSlugsOnUpdate();
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(JobRole::class, 'parent_id');
    }

    public function scopeOnlyParent(Builder $query): Builder
    {
        return $query->whereNull('parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(JobRole::class, 'parent_id');
    }

    public function jobs(): HasMany
    {
        return $this->hasMany(Job::class);
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
