<?php

namespace App\Models\Job;

use App\Models\User\User;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class JobSkill extends Model
{
    use HasUuidTrait, CreatedByTrait, SoftDeletes, HasFactory, HasSlug;

    protected $fillable = [
        'uuid',
        'job_skill_name',
        'job_skill_description',
        'slug',
        'is_active',
        'created_by'
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()->generateSlugsFrom('job_skill_name')->saveSlugsTo('slug')->doNotGenerateSlugsOnUpdate();
    }

    public function jobs(): BelongsToMany
    {
        return $this->belongsToMany(Job::class, 'job_job_skills');
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
} 