<?php

namespace App\Models\Lead;

use App\Enums\LeadStatus;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Kodeine\Metable\Metable;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Lead extends Model implements HasMedia
{
    use CreatedByTrait, HasFactory, HasUuidTrait, InteractsWithMedia, Metable, SoftDeletes;

    protected $fillable = [
        'uuid',
        'lead_form_id',
        'lead_data',
        'lead_source',
        'lead_status',
        'first_name',
        'last_name',
        'email',
        'phone',
        'message',
        'created_by',
    ];

    protected $casts = [
        'lead_data' => 'array',
        'lead_status' => LeadStatus::class,
    ];

    public function leadForm(): BelongsTo
    {
        return $this->belongsTo(LeadForm::class);
    }

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'lead_user')
            ->withPivot('lead_status');
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function leadAddress(): HasMany
    {
        return $this->hasMany(LeadAddress::class);
    }

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('attachments');
    }
}
