<?php

namespace App\Models\Lead;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Location\City;
use App\Models\Location\State;
use App\Models\Location\Country;
class LeadAddress extends Model
{
    use HasFactory;

    protected $fillable = [
        'lead_id',
        'address_line_1',
        'address_line_2',
        'city_id',
        'state_id',
        'country_id',
        'zip_code',
        'latitude',
        'longitude',
    ];

    public function lead(): BelongsTo
    {
        return $this->belongsTo(Lead::class);
    }

    public function city(): BelongsTo
    {
        return $this->belongsTo(City::class);
    }

    public function state(): BelongsTo
    {
        return $this->belongsTo(State::class);
    }

    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }
}

