<?php

namespace App\Models\Lead;

use App\Enums\LeadFormFieldDataType;
use App\Enums\LeadFormFieldType;
use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeadFormFields extends Model
{
    use CreatedByTrait, HasFactory, HasUuidTrait, SoftDeletes;

    protected $fillable = [
        'uuid',
        'field_name',
        'field_id',
        'field_type',
        'data_type',
        'is_default',
        'created_by',
    ];

    protected $casts = [
        'required' => 'boolean',
        'field_options' => 'array',
        'validation_rules' => 'array',
        'data_type' => LeadFormFieldDataType::class,
        'field_type' => LeadFormFieldType::class,
    ];

    public function leadForm(): BelongsTo
    {
        return $this->belongsTo(LeadForm::class);
    }

    public function forms(): BelongsToMany
    {
        return $this->belongsToMany(LeadForm::class, 'field_lead_form', 'field_id', 'lead_form_id')
            ->withPivot([
                'field_placeholder',
                'toggle_yes_text',
                'toggle_no_text',
                'field_columns',
                'help_text',
                'field_options',
                'is_required',
                'is_visible',
                'field_order'
            ]);
    }
}
