<?php

namespace App\Models\Lead;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Traits\HasUuidTrait;
class LeadFormVisit extends Model
{
    use HasFactory, HasUuidTrait;

    public $timestamps = false;

    protected $fillable = [
        'source',
        'lead_form_id',
        'unique_identifier',
        'ip_address',
        'country',
        'state',
        'city',
        'visit_date'
    ];

    public function leadForm(): BelongsTo
    {
        return $this->belongsTo(LeadForm::class);
    }
} 