<?php

namespace App\Models\Location;

use App\Models\Traits\CreatedByTrait;
use App\Models\Traits\HasUuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Image\Enums\Fit;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class City extends Model implements HasMedia
{
    use HasSlug, HasFactory, HasUuidTrait, CreatedByTrait, InteractsWithMedia;

    protected $fillable = [
        'uuid',
        'slug',
        'heading',
        'description',
        'page_data',
        'city_name',
        'state_id',
        'country_id',
        'created_by',
    ];

    protected $casts = [
        'page_data' => 'array',
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('city_name')
            ->saveSlugsTo('slug');
    }

    public function state(): BelongsTo
    {
        return $this->belongsTo(State::class);
    }

    public function country(): BelongsTo
    {
        return $this->belongsTo(Country::class);
    }

    public function areas(): HasMany
    {
        return $this->hasMany(Area::class);
    }

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('featured_image')
            ->singleFile()
            ->registerMediaConversions(function (Media $media) {
                $this->addMediaConversion('thumb')
                    ->fit(Fit::Contain, 300, 300)
                    ->keepOriginalImageFormat()
                    ->sharpen(10);
                $this->addMediaConversion('large')
                    ->fit(Fit::Contain, 1280)
                    ->keepOriginalImageFormat()
                    ->sharpen(10);
            });
    }
}
