<?php

declare(strict_types=1);

namespace App\Models\Membership;

use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Traits\HasUuidTrait;
use App\Models\Traits\CreatedByTrait;


class MembershipPlanAdditionalCost extends Model
{
    use HasFactory, SoftDeletes, HasUuidTrait, CreatedByTrait;

    protected $fillable = [
        'uuid',
        'membership_plan_id',
        'title',
        'price',
        'created_by',
    ];

    protected $casts = [
        'price' => 'decimal:2',
    ];

    public function membershipPlan(): BelongsTo
    {
        return $this->belongsTo(MembershipPlan::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }
} 